-- Si le paramtre de configuration serveur scan for startup procs
-- est dj activ, alors sortir
IF EXISTS(SELECT NULL
          FROM   sys.configurations
          WHERE  name = 'scan for startup procs' 
		    AND  value_in_use = 1)
RETURN;

-- On enregistre la position du paramtre show advanced options
-- pour le repositionner correctement aprs modification
SELECT *
INTO   #T
FROM   sys.configurations
WHERE  name = 'show advanced options' 
  AND  value_in_use = 0;

-- Si ce paramtre est  zro (#T a reu une ligne), alors on lactive
IF @@ROWCOUNT = 1
BEGIN
   EXEC ('EXEC sp_configure ''show advanced options'', 1');
   EXEC ('RECONFIGURE');
END
GO

-- On positionne le paramtre scan for startup procs  1
EXEC sp_configure 'scan for startup procs', 1;
GO
RECONFIGURE
GO

-- remettre 'show advanced options'  0 si #T contient quelque chose
IF EXISTS(SELECT NULL FROM #T)
BEGIN
   EXEC ('EXEC sp_configure ''show advanced options'', 0');
   EXEC ('RECONFIGURE');
END

-- On supprime la table temporaire #T
DROP TABLE #T;
GO